# Element14 Pi-Desktop scripts for LibreELEC

This gist contains the files needed to make Pi-Desktop's power butoon work in LibreELEC.
Due to hardware limitations in the Pi-Desktop this button turns off the Raspberry Pi instead of opening the power menu.

## Setup 
 
1. Install the Raspberry Pi Tools add-on
  - `System (settings)` -> `Add-ons` -> `Install from repozitory` -> `LibreELEC Add-ons` -> `Program add-ons` -> `Raspberry Pi Tools` -> `Install`
2. Get SSH access
  - `System (settings)` -> `LibreELEC` -> `Services` -> `Enable SSH`
    - If you don't setup a password the default is `libreelec`
    - Keep in mind that the default password should be changed or SSH turned off for better security.
  - `System (settings)` -> `LibreELEC` -> `Connections` -> `Address: aaa.bbb.c.ddd`
    - Get the IP address of the device by looking at the connection used
3. SSH to the device: `ssh root@aaa.bbb.c.ddd`
4. Run the install script: `curl -sSL https://opengist.stefka.eu/jiriks74/element14-libreelec/raw/HEAD/install.sh | bash`
5. The light should blink once to indicate that the power button script started successfully
  - It will blink once on every boot to indicate that the Pi comunicates with the power supply

## Manual setup

If you're uncomfortable running a scripts from the internet you can fetch the files yourself and save them like this:

```bash
/storage/scripts/pidesktop/powerkey.py
/storage/.config/system.d/pidesktop-powerkey.service
```
 
Then you need to run `systemctl enable pidesktop-powerkey` to start the scripts on boot and `systemctl start pidekstop-powerkey` to start it now.

The light on the case should blink once to indicate that the script initialized successfully.

## Usage
 
The power key can do 2 things on the Pi Desktop
- When held for 2 seconds it sends a power off signal to the Pi (only once, more keypresses don't do anything)
- When held for 5 seconds it cuts off power from the Pi (as if you unplugged if from wall power)