#!/bin/bash
set -e

mkdir -p /storage/scripts/pidesktop

curl -s "https://opengist.stefka.eu/jiriks74/element14-libreelec/raw/HEAD/powerkey.py" -o /storage/scripts/pidesktop/powerkey.py
curl -s "https://opengist.stefka.eu/jiriks74/element14-libreelec/raw/HEAD/pidesktop-powerkey.service" -o /storage/.config/system.d/pidesktop-powerkey.service

systemctl daemon-reload
systemctl enable pidesktop-powerkey
echo "Watch the case now. The light should blink once/twice to indicate that the the script is working."
sleep 5
systemctl start pidesktop-powerkey

echo "Files installed and set up."
echo "The power button should work now."
echo ""
echo "Disclaimer: Reboot might not be possible anymore. The Pi-Desktop cuts power after 30 seconds of no response from the Pi."
echo "            If the Pi takes more than 30 seconds to reboot the Pi-Desktop will cut it's power and you'll have to turn it on again."
