#!/bin/sh
if [ -d "custom_apps/news" ] && [ -d "apps/news" ]; then
    echo "Couldn't determine News folder as it present both in."
    echo "`apps/news`"
    echo "and in"
    echo "`custom_apps/news`"
    exit 1
elif [ -d "custom_apps/news" ]; then
    curl "https://opengist.stefka.eu/jiriks74/nextcloud-news-fix/raw/HEAD/custom.css" -o custom_apps/news/css/custom.css
elif [ -d "apps/news" ]; then
    curl "https://opengist.stefka.eu/jiriks74/nextcloud-news-fix/raw/HEAD/custom.css" -o apps/news/css/custom.css
else
    echo "Couldn't determine News folder."
    echo "To get the file manually find the news/css folder and run"
    echo
    echo 'curl "https://opengist.stefka.eu/jiriks74/nextcloud-news-fix/raw/HEAD/custom.css" -o custom.css'
    echo
    exit 1
fi